varying vec2 p_textureCoord;

varying vec4 p_color;
uniform sampler2D base_texture;
uniform float base_time;

void main()
{
    float amp = 0.03;
    float freq = 2.0;
    vec4 baseColor = texture2D(base_texture, p_textureCoord);
    float baseSum = baseColor.x + baseColor.y + baseColor.z;
    
    vec2 real_texCoord = vec2(sin(freq * (p_textureCoord.x  - 0.5) * baseSum + base_time) * amp + p_textureCoord.x,
                                      cos(freq * (p_textureCoord.y -0.5) * baseSum + base_time) * amp + p_textureCoord.y);
    vec4 resultColor = texture2D(base_texture, real_texCoord) * p_color;
    gl_FragColor = resultColor;
}
